(* uzywanie typow wartosci w SML.NET *)
structure Demo = struct 
fun main ()= 
    let
	open Classes

	(* Classes.Pair jest typem wartosci, nie typem referencyjnym *)

	fun pr (p:Pair) = 
	    print ("Pair( " ^ (Int.toString (!(p.#x))) ^ ", " ^ (Int.toString (!(p.#y))) ^ ")\n")

	(* domyslna wartosc Pair, z wyzerowanymi polami *)	
	val _ = pr(Pair.null)

	(* tworzenie nowej pary przy uzyciu konstruktora *)
	val _ = pr(Pair(0,1))

	(* wywolanie funkcjonalnej metody na parze *)
        val p = Pair(2,3)
	val q = p.#swap() 
	val _ = pr p
	val _ = pr q

	(* wywolanie destruktywnej metody na parze pozostawia oryginal nietkniety *)
        val p = Pair(4,5)
	val _ = p.#invert() 
	val _ = pr p 

	(* uaktualnienie wartosci pola pary pozostawia oryginal nietkniety *)
        val p = Pair(4,5)
	val _ = p.#x := 5
	val _ = pr p 


	(* wywolanie destruktywnej metody na referencji do pary modyfikuje referencje *)
        val r = ref (Pair(6,7))
	val _ = r.#invert() 
	val _ = pr (!r) 

	(* tak wyglada dostep do pola pary przez referencje *)
        val r = ref (Pair(6,7))
	val _ = r.#x := 7 
	val _ = pr (!r) 

	(* boxing typu wartosci *)
        val Val : System.ValueType = (Pair(8,9) :> System.ValueType)
        val Obj : System.Object = (Pair(10,11) :> System.Object)

	(* unboxing typu wartosci *)
	val p = Obj :> Pair
	val _ = pr p

	val p :> Pair = Obj
	val _ = pr p

        (* niektore rzutowania powodujace unboxing powinny zawiesc *)
	val nonPair = System.Object()
	val _ = (nonPair :> Pair; print "wrong\n")
		handle (e :> System.InvalidCastException) => print ("ok\n")
	    
	(* rzutowania identycznosciowe tez dzialaja *)
	val p = pr(Pair(12,13):>Pair)
    in
	print "done!" 
    end 
end
